// $Id: CWindowIcon.cpp,v 1.6 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CWindowIcon.hpp"
#include <Host/CApplication.hpp>
using Exponent::Host::CApplication;
using Exponent::GUI::Graphics::CWindowIcon;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CWindowIcon, CCountedObject);

//	===========================================================================
CWindowIcon::CWindowIcon()
#ifdef WIN32
		   : m_icon(NULL)
#endif
{
	EXPONENT_CLASS_CONSTRUCTION(CWindowIcon);
#ifdef WIN32
	NULL_POINTER(m_icon);
#endif
}

//	===========================================================================
CWindowIcon::CWindowIcon(const long resourceId)
#ifdef WIN32
		   : m_icon(NULL)
#endif
{
	EXPONENT_CLASS_CONSTRUCTION(CWindowIcon);
	this->loadIcon(resourceId);
}

//	===========================================================================
#ifdef WIN32
CWindowIcon::CWindowIcon(HICON icon)
#ifdef WIN32
		   : m_icon(NULL)
#endif
{
	EXPONENT_CLASS_CONSTRUCTION(CWindowIcon);
	this->setIcon(icon);
}
#endif

//	===========================================================================
CWindowIcon::~CWindowIcon()
{
	EXPONENT_CLASS_DESTRUCTION(CWindowIcon);
	this->unloadIcon();
}

//	===========================================================================
CWindowIcon &CWindowIcon::operator = (const CWindowIcon &icon)
{
#ifdef WIN32
	this->unloadIcon();
	m_icon = icon.getIcon();
#endif
	return (*this);
}

//	===========================================================================
#ifdef WIN32
HICON CWindowIcon::getIcon() const 
{ 
	return m_icon; 
}

//	===========================================================================
void CWindowIcon::setIcon(HICON icon)
{
	this->unloadIcon();
	m_icon = icon;
}
#endif

//	===========================================================================
void CWindowIcon::loadIcon(const long resourceId)
{
#ifdef WIN32
	this->unloadIcon();
	m_icon = LoadIcon(CApplication::getApplicationInstance(), MAKEINTRESOURCE(resourceId));
#endif
}

//	===========================================================================
void CWindowIcon::loadIcon(const CSystemString &path, const long resourceId)
{
#ifdef WIN32
	this->unloadIcon();
	m_icon = ExtractIcon(CApplication::getApplicationInstance(), path.getString(), (UINT)resourceId); 
#endif
}

//	===========================================================================
void CWindowIcon::unloadIcon()
{
#ifdef WIN32
	DestroyIcon(m_icon);
	NULL_POINTER(m_icon);
#endif
}